<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Http\Controllers\Admin\AdmobSettingController;
use App\Http\Controllers\Admin\AppSettingController;
use App\Http\Controllers\Admin\AudioLeaderboardController;
use App\Http\Controllers\Admin\AudioQuestionController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\LevelController;
use App\Http\Controllers\Admin\ClassificationController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\AvatarController;
use App\Http\Controllers\Admin\BadgeSettingController;
use App\Http\Controllers\Admin\BattlesQuestionController;
use App\Http\Controllers\Admin\CoinSettingController;
use App\Http\Controllers\Admin\ContestController;
use App\Http\Controllers\Admin\DailyQuizLeaderboardController;
use App\Http\Controllers\Admin\DailyQuizQuestionController;
use App\Http\Controllers\Admin\WithdrawalController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\TransactionController;
use App\Http\Controllers\Admin\PaymentController;
use App\Http\Controllers\Admin\ExamController;
use App\Http\Controllers\Admin\FaceBookAdsSettingController;
use App\Http\Controllers\Admin\FearFactorLeaderboardController;
use App\Http\Controllers\Admin\FearFactorQuestionController;
use App\Http\Controllers\Admin\GroupBattlesController;
use App\Http\Controllers\Admin\LoginController;
use App\Http\Controllers\Admin\NormalLeaderboardController;
use App\Http\Controllers\Admin\NormalQuestionController;
use App\Http\Controllers\Admin\OneVsOneBattlesController;
use App\Http\Controllers\Admin\PanelSettingController;
use App\Http\Controllers\Admin\PraticeLeaderboardController;
use App\Http\Controllers\Admin\PraticeQuestionController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\ProductTransactionController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\QuizConfigurationController;
use App\Http\Controllers\Admin\SkillController;
use App\Http\Controllers\Admin\SystemSettingController;
use App\Http\Controllers\Admin\TrueFalseLeaderboardController;
use App\Http\Controllers\Admin\TrueFalseQuestionController;
use App\Http\Controllers\Admin\UltimateChallengeController;
use App\Http\Controllers\Admin\VideoLeaderboardController;
use App\Http\Controllers\Admin\VideoQuestionController;

Route::group(['middleware' => 'installation'], function () {

    // Login-Logout
    Route::get('login', [LoginController::class, 'login'])->name('admin.login');
    Route::post('login', [LoginController::class, 'save_login'])->name('admin.save.login');
    Route::get('logout', [LoginController::class, 'logout'])->name('admin.logout');

    Route::group(['middleware' => 'authadmin', 'as' => 'admin.'], function () {

        // Dashboard
        Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');
        // Profile
        Route::resource('profile', ProfileController::class)->only(['index', 'store']);
        Route::post('profile/changepassword', [ProfileController::class, 'ChangePassword'])->name('profile.changepassword');
        // Category
        Route::resource('category', CategoryController::class)->only(['index', 'store', 'update', 'show']);
        Route::post('category/sortorder/save', [CategoryController::class, 'sort_order_save'])->name('category.sortorder.save');
        // Level
        Route::resource('level', LevelController::class)->only(['index', 'store', 'update', 'show']);
        Route::post('level/sortorder/save', [LevelController::class, 'sort_order_save'])->name('level.sortorder.save');
        // Skill
        Route::resource('skill', SkillController::class)->only(['index', 'store', 'update', 'show']);
        Route::post('skill/sortorder/save', [SkillController::class, 'sort_order_save'])->name('skill.sortorder.save');
        // Classification
        Route::resource('classification', ClassificationController::class)->only(['index', 'store', 'update', 'show']);
        Route::post('classification/sortorder/save', [ClassificationController::class, 'sort_order_save'])->name('classification.sortorder.save');
        // Avatar
        Route::resource('avatar', AvatarController::class)->only(['index', 'store', 'update', 'show']);
        Route::post('avatar/sortorder/save', [AvatarController::class, 'sort_order_save'])->name('avatar.sortorder.save');
        // User
        Route::resource('user', UserController::class)->only(['index', 'create', 'store', 'edit', 'update', 'show']);
        Route::get('user/dashboard/{id}', [UserController::class, 'dashboard'])->name('user.dashboard');
        // Pages
        Route::resource('page', PageController::class)->only(['index', 'create', 'store', 'edit', 'update', 'show']);
        Route::post('page/layout', [PageController::class, 'page_layout'])->name('page.layout.save');
        // Payment
        Route::resource('payment', PaymentController::class)->only(['index']);
        // Quiz Configuration
        Route::resource('quizconfiguration', QuizConfigurationController::class)->only(['index', 'show', 'edit', 'update']);
        // Pratice Question
        Route::resource('praticequestion', PraticeQuestionController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);
        Route::get('praticequestion-import', [PraticeQuestionController::class, 'import_export_index'])->name('praticequestion.import.index');
        Route::get('praticequestion-export', [PraticeQuestionController::class, 'export'])->name('praticequestion.export');
        Route::post('praticequestion-import/save', [PraticeQuestionController::class, 'import'])->name('praticequestion.import.save');
        // Pratice Leaderboard
        Route::resource('praticeleaderboard', PraticeLeaderboardController::class)->only(['index']);
        // Normal Question
        Route::resource('normalquestion', NormalQuestionController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);
        Route::get('normalquestion-import', [NormalQuestionController::class, 'import_export_index'])->name('normalquestion.import.index');
        Route::get('normalquestion-export', [NormalQuestionController::class, 'export'])->name('normalquestion.export');
        Route::post('normalquestion-import/save', [NormalQuestionController::class, 'import'])->name('normalquestion.import.save');
        // Normal Leaderboard
        Route::resource('normalleaderboard', NormalLeaderboardController::class)->only(['index']);
        // Audio Question
        Route::resource('audioquestion', AudioQuestionController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);
        Route::get('audioquestion-import', [AudioQuestionController::class, 'import_export_index'])->name('audioquestion.import.index');
        Route::get('audioquestion-export', [AudioQuestionController::class, 'export'])->name('audioquestion.export');
        Route::post('audioquestion-import/save', [AudioQuestionController::class, 'import'])->name('audioquestion.import.save');
        // Audio Leaderboard
        Route::resource('audioleaderboard', AudioLeaderboardController::class)->only(['index']);
        // Audio Question
        Route::resource('audioquestion', AudioQuestionController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);
        Route::get('audioquestion-import', [AudioQuestionController::class, 'import_export_index'])->name('audioquestion.import.index');
        Route::get('audioquestion-export', [AudioQuestionController::class, 'export'])->name('audioquestion.export');
        Route::post('audioquestion-import/save', [AudioQuestionController::class, 'import'])->name('audioquestion.import.save');
        // Audio Leaderboard
        Route::resource('audioleaderboard', AudioLeaderboardController::class)->only(['index']);
        // Video Question
        Route::resource('videoquestion', VideoQuestionController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);
        Route::get('videoquestion-import', [VideoQuestionController::class, 'import_export_index'])->name('videoquestion.import.index');
        Route::get('videoquestion-export', [VideoQuestionController::class, 'export'])->name('videoquestion.export');
        Route::post('videoquestion-import/save', [VideoQuestionController::class, 'import'])->name('videoquestion.import.save');
        // Video Leaderboard
        Route::resource('videoleaderboard', VideoLeaderboardController::class)->only(['index']);
        // True-False Question
        Route::resource('truefalsequestion', TrueFalseQuestionController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);
        Route::get('truefalsequestion-import', [TrueFalseQuestionController::class, 'import_export_index'])->name('truefalsequestion.import.index');
        Route::get('truefalsequestion-export', [TrueFalseQuestionController::class, 'export'])->name('truefalsequestion.export');
        Route::post('truefalsequestion-import/save', [TrueFalseQuestionController::class, 'import'])->name('truefalsequestion.import.save');
        // True-False Leaderboard
        Route::resource('truefalseleaderboard', TrueFalseLeaderboardController::class)->only(['index']);
        // Daily Quiz Question
        Route::resource('dailyquizquestion', DailyQuizQuestionController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);
        Route::get('dailyquizquestion-import', [DailyQuizQuestionController::class, 'import_export_index'])->name('dailyquizquestion.import.index');
        Route::get('dailyquizquestion-export', [DailyQuizQuestionController::class, 'export'])->name('dailyquizquestion.export');
        Route::post('dailyquizquestion-import/save', [DailyQuizQuestionController::class, 'import'])->name('dailyquizquestion.import.save');
        // Daily Quiz Leaderboard
        Route::resource('dailyquizleaderboard', DailyQuizLeaderboardController::class)->only(['index']);
        // Fear Factor Question
        Route::resource('fearfactorquestion', FearFactorQuestionController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);
        Route::get('fearfactorquestion-import', [FearFactorQuestionController::class, 'import_export_index'])->name('fearfactorquestion.import.index');
        Route::get('fearfactorquestion-export', [FearFactorQuestionController::class, 'export'])->name('fearfactorquestion.export');
        Route::post('fearfactorquestion-import/save', [FearFactorQuestionController::class, 'import'])->name('fearfactorquestion.import.save');
        // Fear Factor Leaderboard
        Route::resource('fearfactorleaderboard', FearFactorLeaderboardController::class)->only(['index']);
        // Ultimate Challenge
        Route::resource('ultimatechallenge', UltimateChallengeController::class)->only(['index', 'store', 'update', 'show']);
        Route::get('ultimatechallenge/question/{id}', [UltimateChallengeController::class, 'question_index'])->name('ultimatechallenge.question.index');
        Route::post('ultimatechallenge/question/save', [UltimateChallengeController::class, 'question_save'])->name('ultimatechallenge.question.save');
        Route::get('ultimatechallenge/question/show/{id}', [UltimateChallengeController::class, 'question_show'])->name('ultimatechallenge.question.show');
        Route::get('ultimatechallengequestion-export', [UltimateChallengeController::class, 'export'])->name('ultimatechallenge.question.export');
        Route::post('ultimatechallengequestion-import/save', [UltimateChallengeController::class, 'import'])->name('ultimatechallenge.question.import.save');
        Route::post('ultimatechallenge/question/update/{id}', [UltimateChallengeController::class, 'question_update'])->name('ultimatechallenge.question.update');
        Route::get('ultimatechallenge/leaderboard/{id}', [UltimateChallengeController::class, 'leaderboard'])->name('ultimatechallenge.leaderboard');
        // Contest
        Route::resource('contests', ContestController::class)->only(['index', 'create', 'store', 'update', 'show']);
        Route::get('contests/leaderboard/{id}', [ContestController::class, 'leaderboard'])->name('contests.leaderboard');
        Route::get('contests/question/{id}', [ContestController::class, 'question_index'])->name('contests.question.index');
        Route::post('contests/question/save', [ContestController::class, 'question_save'])->name('contests.question.save');
        Route::get('contests/question/show/{id}', [ContestController::class, 'question_show'])->name('contests.question.show');
        Route::get('contests-export', [ContestController::class, 'export'])->name('contests.question.export');
        Route::post('contests-import/save', [ContestController::class, 'import'])->name('contests.question.import.save');
        Route::post('contests/question/update/{id}', [ContestController::class, 'question_update'])->name('contests.question.update');
        // Exam
        Route::resource('exam', ExamController::class)->only(['index', 'store', 'update', 'show']);
        Route::get('exam/question/{id}', [ExamController::class, 'question_index'])->name('exam.question.index');
        Route::post('exam/question/save', [ExamController::class, 'question_save'])->name('exam.question.save');
        Route::get('exam/question/show/{id}', [ExamController::class, 'question_show'])->name('exam.question.show');
        Route::get('exam-export', [ExamController::class, 'export'])->name('exam.question.export');
        Route::post('exam-import/save', [ExamController::class, 'import'])->name('exam.question.import.save');
        Route::post('exam/question/update/{id}', [ExamController::class, 'question_update'])->name('exam.question.update');
        Route::get('exam/leaderboard/{id}', [ExamController::class, 'leaderboard'])->name('exam.leaderboard');
        // App Setting
        Route::get('appsetting', [AppSettingController::class, 'index'])->name('appsetting.index');
        Route::post('appsetting/app', [AppSettingController::class, 'app'])->name('appsetting.app');
        Route::post('appsetting/currency', [AppSettingController::class, 'currency'])->name('appsetting.currency');
        Route::post('appsetting/smtp', [AppSettingController::class, 'smtp'])->name('appsetting.smtp');
        Route::post('appsetting/sociallink', [AppSettingController::class, 'sociallink'])->name('appsetting.sociallink');
        Route::post('appsetting/onboardingscreen', [AppSettingController::class, 'onboardingscreen'])->name('appsetting.onboardingscreen');
        Route::post('appsetting/referearn', [AppSettingController::class, 'referearn'])->name('appsetting.referearn');
        Route::post('appsetting/appdownload', [AppSettingController::class, 'appdownload'])->name('appsetting.appdownload');
        Route::post('appsetting/emailtest', [AppSettingController::class, 'emailtest'])->name('appsetting.emailtest');
        // Admob
        Route::resource('admob', AdmobSettingController::class)->only(['index']);
        Route::post('admob/status', [AdmobSettingController::class, 'admobStatus'])->name('admob.status');
        Route::post('admob/android', [AdmobSettingController::class, 'admobAndroid'])->name('admob.android');
        Route::post('admob/ios', [AdmobSettingController::class, 'admobIos'])->name('admob.ios');
        // FaceBook Ads
        Route::resource('fbads', FaceBookAdsSettingController::class)->only(['index']);
        Route::post('fbads/status', [FaceBookAdsSettingController::class, 'facebookadStatus'])->name('fbads.status');
        Route::post('fbads/android', [FaceBookAdsSettingController::class, 'facebookadAndroid'])->name('fbads.android');
        Route::post('fbads/ios', [FaceBookAdsSettingController::class, 'facebookadIos'])->name('fbads.ios');
        // Panel Setting
        Route::get('panelsetting', [PanelSettingController::class, 'index'])->name('panelsetting.index');
        Route::post('panelsetting/save', [PanelSettingController::class, 'save'])->name('panelsetting.save');
        Route::post('panelsetting/companyinfo', [PanelSettingController::class, 'company_info'])->name('panelsetting.companyinfo');        
        // Coin Setting
        Route::get('coinsetting', [CoinSettingController::class, 'index'])->name('coinsetting');
        Route::post('coinsetting/spin_wheel', [CoinSettingController::class, 'spin_wheel'])->name('coinsetting.spin_wheel');
        Route::post('coinsetting/daily_reward', [CoinSettingController::class, 'daily_reward'])->name('coinsetting.daily_reward');
        Route::post('coinsetting/ads_free_coin', [CoinSettingController::class, 'ads_free_coin'])->name('coinsetting.ads_free_coin');
        Route::post('coinsetting/withdrawal', [CoinSettingController::class, 'withdrawal'])->name('coinsetting.withdrawal');
        Route::post('coinsetting/coin_share', [CoinSettingController::class, 'coin_share'])->name('coinsetting.coin_share');
        // Package
        Route::resource('package', PackageController::class)->only(['index', 'create', 'store', 'edit', 'update', 'show']);
        // Transaction
        Route::resource('transaction', TransactionController::class)->only(['index', 'create', 'store']);
        Route::any('search_user', [TransactionController::class, 'search_user'])->name('search_user');
        // Notification
        Route::resource('notification', NotificationController::class)->only(['index', 'store']);
        // Battles Question
        Route::resource('battlesquestion', BattlesQuestionController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);
        Route::get('battlesquestion-import', [BattlesQuestionController::class, 'import_export_index'])->name('battlesquestion.import.index');
        Route::get('battlesquestion-export', [BattlesQuestionController::class, 'export'])->name('battlesquestion.export');
        Route::post('battlesquestion-import/save', [BattlesQuestionController::class, 'import'])->name('battlesquestion.import.save');
        // 1 vs 1 Battles
        Route::resource('one-vs-one-battles', OneVsOneBattlesController::class)->only(['index', 'show'])->names('one_vs_one_battles');
        // Group Battles
        Route::resource('group-battles', GroupBattlesController::class)->only(['index', 'show'])->names('group_battles');
        // Badge Setting
        Route::get('badgesetting', [BadgeSettingController::class, 'index'])->name('badge.setting');
        Route::post('badgesetting/save', [BadgeSettingController::class, 'save'])->name('badge.setting.save');
        Route::post('badgesetting/status/{id}', [BadgeSettingController::class, 'status'])->name('badge.setting.status');
        // Withdrawal
        Route::resource('withdrawal', WithdrawalController::class)->only(['index', 'show']);
        // Product
        Route::resource('product', ProductController::class)->only(['index', 'create', 'store', 'edit', 'update', 'show']);
        // Product Transaction
        Route::resource('product-transaction', ProductTransactionController::class)->only(['index', 'show'])->names('producttransaction');
        // System Setting
        Route::get('systemsetting', [SystemSettingController::class, 'index'])->name('systemsetting.index');
        Route::post('systemsetting/cleardata', [SystemSettingController::class, 'ClearData'])->name('systemsetting.cleardata');
        Route::post('systemsetting/cleandatabase', [SystemSettingController::class, 'CleanDatabase'])->name('systemsetting.cleandatabase');

        Route::group(['middleware' => 'checkadmin'], function () {

            // Category
            Route::resource('category', CategoryController::class)->only(['destroy']);
            // Level
            Route::resource('level', LevelController::class)->only(['destroy']);
            // Skill
            Route::resource('skill', SkillController::class)->only(['destroy']);
            // Classification
            Route::resource('classification', ClassificationController::class)->only(['destroy']);
            // Avatar
            Route::resource('avatar', AvatarController::class)->only(['destroy']);
            // User
            Route::resource('user', UserController::class)->only(['destroy']);
            // Page
            Route::resource('page', PageController::class)->only(['destroy']);
            // Payment
            Route::resource('payment', PaymentController::class)->only(['edit', 'update']);
            // Pratice Question
            Route::resource('praticequestion', PraticeQuestionController::class)->only(['destroy']);
            // Normal Question
            Route::resource('normalquestion', NormalQuestionController::class)->only(['destroy']);
            // Audio Question
            Route::resource('audioquestion', AudioQuestionController::class)->only(['destroy']);
            // Video Question
            Route::resource('videoquestion', VideoQuestionController::class)->only(['destroy']);
            // True-False Question
            Route::resource('truefalsequestion', TrueFalseQuestionController::class)->only(['destroy']);
            // Daily Quiz Question
            Route::resource('dailyquizquestion', DailyQuizQuestionController::class)->only(['destroy']);
            // Fear Factor Question
            Route::resource('fearfactorquestion', FearFactorQuestionController::class)->only(['destroy']);
            // Ultimate Challenge
            Route::resource('ultimatechallenge', UltimateChallengeController::class)->only(['destroy']);
            Route::post('ultimatechallenge/question/delete/{ultimate_challenge_id}/{id}', [UltimateChallengeController::class, 'question_delete'])->name('ultimatechallenge.question.delete');
            // Contest
            Route::resource('contests', ContestController::class)->only(['destroy']);
            Route::get('contests/makewinner/{id}', [ContestController::class, 'make_winner'])->name('contests.makewinner');
            Route::post('contests/question/delete/{id}', [ContestController::class, 'question_delete'])->name('contests.question.delete');
            // Exam
            Route::resource('exam', ExamController::class)->only(['destroy']);
            Route::post('exam/question/delete/{exam_id}/{id}', [ExamController::class, 'question_delete'])->name('exam.question.delete');
            // Package
            Route::resource('package', PackageController::class)->only(['destroy']);
            // Transaction
            Route::resource('transaction', TransactionController::class)->only(['destroy']);
            // Notification
            Route::resource('notification', NotificationController::class)->only(['destroy']);
            Route::get('notifications/setting', [NotificationController::class, 'setting'])->name('notification.setting');
            Route::post('notifications/setting', [NotificationController::class, 'settingsave'])->name('notification.settingsave');
            // Battles Question
            Route::resource('battlesquestion', BattlesQuestionController::class)->only(['destroy']);
            // 1 vs 1 Battles
            Route::resource('one-vs-one-battles', OneVsOneBattlesController::class)->only(['destroy'])->names('one_vs_one_battles');
            // Group Battles
            Route::resource('group-battles', GroupBattlesController::class)->only(['destroy'])->names('group_battles');
            // Product
            Route::resource('product', ProductController::class)->only(['destroy']);
            // System Settings
            Route::get('systemsetting/downloadsqlfile', [SystemSettingController::class, 'DownloadSqlFile'])->name('systemsetting.downloadsqlfile');
        });
    });
});
